/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.charts;

import edu.colorado.phet.common.charts.AbstractGrid;
import edu.colorado.phet.common.charts.Chart;
import edu.colorado.phet.common.charts.LabelTable;
import edu.colorado.phet.common.charts.Orientation;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public abstract class AbstractTicks
extends AbstractGrid {
    private int tickHeight = 6;
    private NumberFormat numberFormat = new DecimalFormat("#.#");
    private Font font = new PhetFont(0, 12);
    private boolean showLabels = true;
    private GraphicLayerSet tickGraphics;
    private GraphicLayerSet labelGraphics;
    private LabelTable labelTable;
    private boolean rangeLabelsVisible = false;
    private NumberFormat rangeLabelsNumberFormat = new DecimalFormat("#.#");

    public AbstractTicks(Chart chart, Orientation orientation, Stroke stroke, Color color, double d) {
        this(chart, orientation, stroke, color, d, 0.0);
    }

    public AbstractTicks(Chart chart, Orientation orientation, Stroke stroke, Color color, double d, double d2) {
        super(chart, orientation, stroke, color, d, d2);
        this.tickGraphics = new GraphicLayerSet(chart.getComponent());
        this.labelGraphics = new GraphicLayerSet(chart.getComponent());
        this.addGraphic(this.tickGraphics);
        this.addGraphic(this.labelGraphics);
        chart.addListener(new Chart.Listener(){

            public void transformChanged(Chart chart) {
                AbstractTicks.this.update();
            }
        });
        this.update();
    }

    protected void update() {
        this.labelGraphics.clear();
        this.tickGraphics.clear();
        double[] dArray = this.getVisibleGridlines();
        if (this.getOrientation().isVertical()) {
            this.addVerticalStuff(dArray);
        } else if (this.getOrientation().isHorizontal()) {
            this.addHorizontalStuff(dArray);
        }
    }

    private void addHorizontalStuff(double[] dArray) {
        Chart chart = this.getChart();
        for (int i = 0; i < dArray.length; ++i) {
            double d = dArray[i];
            if (!chart.getRange().containsY(d)) continue;
            this.addHorizontalTick(this.numberFormat, d);
        }
        if (this.labelTable != null) {
            double[] dArray2 = this.labelTable.keys();
            for (int i = 0; i < dArray2.length; ++i) {
                double d = dArray2[i];
                if (!chart.getRange().containsY(d)) continue;
                PhetGraphic phetGraphic = this.getVerticalLabelFromTable(d);
                phetGraphic.setVisible(this.showLabels);
                this.labelGraphics.addGraphic(phetGraphic);
            }
        }
        if (this.rangeLabelsVisible) {
            this.addHorizontalTick(this.rangeLabelsNumberFormat, chart.getRange().getMinY());
            this.addHorizontalTick(this.rangeLabelsNumberFormat, chart.getRange().getMaxY());
        }
    }

    private void addHorizontalTick(NumberFormat numberFormat, double d) {
        Chart chart = this.getChart();
        int n = this.getVerticalTickX();
        int n2 = chart.transformY(d);
        Line2D.Double double_ = new Line2D.Double(n - this.tickHeight / 2, n2, n + this.tickHeight / 2, n2);
        PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(chart.getComponent(), double_, this.getStroke(), this.getColor());
        this.tickGraphics.addGraphic(phetShapeGraphic);
        if (this.labelTable == null) {
            String string = numberFormat.format(d);
            PhetTextGraphic phetTextGraphic = new PhetTextGraphic(chart.getComponent(), this.font, string, this.getColor());
            phetTextGraphic.setLocation(n - this.tickHeight / 2 - phetTextGraphic.getWidth(), n2 - phetTextGraphic.getHeight() / 2);
            phetTextGraphic.setVisible(this.showLabels);
            this.labelGraphics.addGraphic(phetTextGraphic);
        }
    }

    public PhetGraphic getHorizontalLabelFromTable(double d) {
        int n = this.getChart().transformX(d);
        int n2 = this.getHorizontalTickY();
        PhetGraphic phetGraphic = this.labelTable.get(d);
        phetGraphic.setLocation(n - phetGraphic.getWidth() / 2, n2 + this.tickHeight + 1);
        return phetGraphic;
    }

    private void addVerticalStuff(double[] dArray) {
        Chart chart = this.getChart();
        for (int i = 0; i < dArray.length; ++i) {
            double d = dArray[i];
            if (!chart.getRange().containsX(d)) continue;
            this.addVerticalTick(this.numberFormat, d);
        }
        if (this.labelTable != null) {
            double[] dArray2 = this.labelTable.keys();
            for (int i = 0; i < dArray2.length; ++i) {
                double d = dArray2[i];
                if (!chart.getRange().containsX(d)) continue;
                PhetGraphic phetGraphic = this.getHorizontalLabelFromTable(d);
                phetGraphic.setVisible(this.showLabels);
                this.labelGraphics.addGraphic(phetGraphic);
            }
        }
        if (this.rangeLabelsVisible) {
            this.addVerticalTick(this.rangeLabelsNumberFormat, chart.getRange().getMinX());
            this.addVerticalTick(this.rangeLabelsNumberFormat, chart.getRange().getMaxX());
        }
    }

    private void addVerticalTick(NumberFormat numberFormat, double d) {
        Chart chart = this.getChart();
        int n = chart.transformX(d);
        int n2 = this.getHorizontalTickY();
        Line2D.Double double_ = new Line2D.Double(n, n2 - this.tickHeight / 2, n, n2 + this.tickHeight / 2);
        PhetShapeGraphic phetShapeGraphic = new PhetShapeGraphic(chart.getComponent(), double_, this.getStroke(), this.getColor());
        this.tickGraphics.addGraphic(phetShapeGraphic);
        if (this.labelTable == null) {
            String string = numberFormat.format(d);
            PhetTextGraphic phetTextGraphic = new PhetTextGraphic(chart.getComponent(), this.font, string, this.getColor());
            phetTextGraphic.setLocation(n - phetTextGraphic.getWidth() / 2, n2 + this.tickHeight / 2 + 4);
            phetTextGraphic.setVisible(this.showLabels);
            this.labelGraphics.addGraphic(phetTextGraphic);
        }
    }

    public PhetGraphic getVerticalLabelFromTable(double d) {
        int n = this.getVerticalTickX();
        int n2 = this.getChart().transformY(d);
        PhetGraphic phetGraphic = this.labelTable.get(d);
        phetGraphic.setLocation(n - this.tickHeight / 2 - phetGraphic.getWidth(), n2 - phetGraphic.getHeight() / 2);
        return phetGraphic;
    }

    public void setShowLabels(boolean bl) {
        this.showLabels = bl;
        this.update();
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
        this.update();
    }

    public void setLabelsVisible(boolean bl) {
        this.showLabels = bl;
        this.update();
    }

    public abstract int getVerticalTickX();

    public abstract int getHorizontalTickY();

    public void setRangeLabelsVisible(boolean bl) {
        this.rangeLabelsVisible = bl;
        this.update();
    }
}

